ServerEvents.recipes(event => {
  const ids = [
      'endrem:witch_eye',
      'endrem:undead_eye',
      'endrem:exotic_eye',
      'explorerscompass:explorers_compass',
      'cookingforblockheads:heating_unit',
      'minecraft:cut_copper_from_copper_block_stonecutting',
      'kibe:chunk_loader',
      'kibe:wither_proof_block',
      'kibe:obsidian_sand',
      'kibe:wither_proof_sand',
      'kibe:wither_proof_glass',
      'kibe:angel_ring',
      'kibe:slime_boots',
      'kibe:slime_sling',
      'kibe:entangled_chest',
      'kibe:entangled_bag',
      'coxinhautilities:golden_coxinha',
      'coxinhautilities:diamond_coxinha',
      'coxinhautilities:cardboard_box/cardboard_box_saw_dust',
      'coxinhautilities:cardboard_box/cardboard_box',
      'openblocks:elevator_block',
      'kibe:big_torch'
  ]
  ids.forEach(id => {
      event.remove({id: id})
  })
  event.remove({output: 'indrev:gold_plate', type: 'create:pressing'})
  event.remove({mod: 'campanion'})


  event.shaped('travelersbackpack:white_sleeping_bag', ['SSS', 'S S', 'SSS'], {
    S: 'handcrafted:white_sheet'})
    
  event.shapeless('8x handcrafted:white_sheet', ['travelersbackpack:white_sleeping_bag'])
  // Crude Elytra
  event.shaped(Item.of('minecraft:elytra', "{Damage:0,RepairCost:255,display:{Name:'{\"text\":\"Crude Elytra\"}'},selected:{}}"), ['FMF','MRM','L L'], {
      F: 'minecraft:feather',
      M: 'minecraft:phantom_membrane',
      R: 'supplementaries:rope',
      L: 'minecraft:leather'})
      
  let elytra = Item.of('minecraft:elytra', "{RepairCost:255,display:{Name:'{\"text\":\"Crude Elytra\"}'},selected:{}}")
      event.shapeless(elytra,
      [elytra,elytra])
  
  event.shapeless('supplementaries:flute', [Item.of('supplementaries:flute').ignoreNBT()])

  // Enchanted Golden Apple
  event.shaped('minecraft:enchanted_golden_apple', ['GGG','GAG','GGG'], {
      G: 'minecraft:gold_block',
      A: 'minecraft:apple'
  })

  event.shaped('minecraft:bundle', [
    'SHS', 
    'H H', 
    'HHH'
    ], {
    S: 'minecraft:string',
    H: 'minecraft:rabbit_hide'
  })

  event.shaped('lote:inactive_guardian_eye', ['S  ',' CS', ' S '], {
    S: 'lote:guardian_fragment',
    C: 'minecraft:conduit'
  })

  event.remove({id: 'clickmachine:auto_clicker'})
  event.shaped('clickmachine:auto_clicker', ['PPP', 'PDP', 'PRP'], {
    P: 'minecraft:polished_diorite',
    D: 'minecraft:dispenser',
    R: 'minecraft:redstone_block'
  })

  event.shaped('supplementaries:quiver', ['RLL', 'LAL', ' L '], {
    R: 'supplementaries:rope',
    L: 'minecraft:leather',
    A: '2x minecraft:arrow'
  })
  
  const colors = ['white', 'orange', 'magenta', 'light_blue', 'yellow', 'lime', 'pink', 'gray', 'light_gray', 'cyan', 'purple', 'blue', 'brown', 'green', 'red', 'black']
  colors.forEach(color => {
    event.shapeless(`minecraft:${color}_wool`, [`minecraft:${color}_dye`, `#minecraft:wool`])

})
    event.remove({output: 'ae2:certus_quartz_dust'})

  
    event.shaped('adventurez:piglin_flag_block', ['GSG', 'SBS', 'GSG'], {
      G: 'minecraft:gold_ingot',
      S: 'adventurez:gilded_stone',
      B: 'supplementaries:flag_black'
        })
  const indrevPlates = [
    'tungsten',
    'tin',
    'steel',
    'silver',
    'lead',
    'electrum',
    'copper',
    'bronze'
  ]
  indrevPlates.forEach(mat =>{  
    event.custom(
      {
        "type": "create:pressing",
        "ingredients": [
            {
                "tag": "c:"+mat+"_ingots"
            }
        ],
        "results": [
            {
                "item": "indrev:"+mat+"_plate"
            }
        ]
    }
    )

  })

  const witherproof = [
    'minecraft:nether_star',
    'indrev:wither_proof_obsidian'
  ]
  event.remove({output: 'indrev:wither_proof_obsidian'})
  witherproof.forEach(item =>{
    event.shaped('2x indrev:wither_proof_obsidian', ['BOB', 'OXO','BOB'], {
      B: 'minecraft:iron_bars',
      O: 'minecraft:obsidian',
      X: item
    })
  })

  let multiSmelt = (output, input, includeBlasting) => {
    event.smelting(output, input)
    
    if (includeBlasting) {
      event.blasting(output, input)
    }
  }
  const missingOre = [
    'tin',
    'lead',
    'silver'
  ]
  missingOre.forEach(mat =>{  multiSmelt('indrev:'+mat+'_ingot','create:crushed_raw_'+mat, true)
  })
})

// Dull Eye Wandering Trader
MoreJSEvents.wandererTrades(event => {
    const level = 2
        const input = Item.of('supplementaries:cage', '{BlockEntityTag:{MobHolder:{EntityData:{id:"minecraft:frog"}}}}')
    const output = 'lote:dull_eye'
    for (let i = 0; i < 50; i++){
        event.addTrade(level, input, output);
    }
})

// Blazing Geode Cleric
MoreJSEvents.villagerTrades((event) => {
    const level = 5

    const cleric = 'cleric'
    const clericInput = ['15x minecraft:emerald','create:blaze_burner']
    const clericOutput = 'lote:blazing_geode'
    event.removeModdedTrades([cleric], level);
    for (let i = 0; i < 5; i++) event.addTrade(cleric, level, clericInput, clericOutput);


    const cartographer = 'cartographer'
    const cartographerInput = ['minecraft:recovery_compass', '16x waystones:warp_dust']
    const cartographerOutput = 'explorerscompass:explorerscompass'
    //event.removeModdedTrades([cartographer], level);
    event.addTrade(cartographer, level, cartographerInput, cartographerOutput);
})
